"""
Przykład z podrozdziału "Wieloprocesowość"
pokazujący, jak utworzyć nowy proces za pomocą 
wywołania os.fork w systemach posiksowych.

"""
import os

pid_list = []


def main():
    pid_list.append(os.getpid())
    child_pid = os.fork()

    if child_pid == 0:
        pid_list.append(os.getpid())
        print()
        print("POTOMNY: cześć, jestem procesem potomnym")
        print("POTOMNY: oto wszystkie znane mi identyfikatory PID %s" % pid_list)

    else:
        pid_list.append(os.getpid())
        print()
        print("RODZIC: cześć, jestem procesem-rodzicem ")
        print("RODZIC: identyfikator PID procesu potomnego to %d" % child_pid)
        print("RODZIC: oto wszystkie znane mi identyfikatory PID: %s" % pid_list)


if __name__ == "__main__":
    main()
